#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

unsigned char cypher[] = "4MW7UFHPD5BK8R2TYVN3QCSAG9EZLJ6X";
unsigned char sern[] = "GMM-AA-REVNET-0000-0000";
unsigned char key[] = "B82YZ2222VKRTVF4444JM7FPWWUHD7L2";

// 0 0 0 0 - Group 0 = Maximum groups (pos in key 10..13)
// 1 1 1 1 - Group 1 = First half of serial# (pos in key 5..8)
// 2 2 2 2 - Group 2 = Maximum members (pos in key 0..3)
// 3 3 3 3 - Group 3 = Second half of serial# (pos in key 15..18)
//
// Pos in key 25..28 are subtracted from Groups 0 and 1
// Pos in key 20..23 are subtracted from Groups 2 and 3
// All the rest eval. to "AAREVNET" as follows [30]-5, [9]+6, [14]+8, [29]-9, [4]-10, [19]-11, [31]+12, [24]+13
//
// See xlatpos() for proper digit-group placement
//

int xlatpos(int pos, int grp)
{
	pos -= grp;
	if (pos < 0)
		pos += 4;

	return pos;
}

int lookup(char let)
{
	int i=0;

	while (cypher[i] && cypher[i] != let)
		i++;

	return i;
}

void makekey()
{
	int i, num;


	for (i=0; i<4; i++) {
		num = random(10);
		sern[14 + i] += num;
		key[5 + xlatpos(i, 1)] = cypher[ lookup(key[25 + xlatpos(i, 1)]) + num ];

		num = random(10);
		sern[19 + i] += num;
		key[15 + xlatpos(i, 3)] = cypher[ lookup(key[20 + xlatpos(i, 3)]) + num ];
	}
}

void main()
{
	printf("GroupMaster v1.4 Serial# and Software Key generator\n");
	randomize();
	makekey();
	printf("\n");
	printf("Serial Number : %s\n", sern);
	printf("Software Key  : %s\n", key);
}
